<?php

namespace App\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'User';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function UserOwnsHost()
    {
        return $this->hasMany('Hosts');
    }

    public function UserHasAccessInScansHost()
    {
        return $this->hasOne('Scans');
    }

}